package TextLCD;

import com.phidgets.TextLCDPhidget;
import com.phidgets.PhidgetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import listeners.*;
import misc.TextFieldLimiter;

public class TextLCD extends javax.swing.JFrame {

    private static String runArgs[];
    private TextLCDPhidget lcd;
    private Hashtable screenSizeHashTable;
    private final int maxColumnSize = 40;
    private int currScreen;
    private String[][] textOriginals = new String[maxColumnSize][maxColumnSize];
    private LCDAttachListener attach_listener;
    private LCDDetachListener detach_listener;
    private LCDErrorListener error_listener;

    /** Creates new form TextLCD */
    public TextLCD() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        attachedTxt = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        serialTxt = new javax.swing.JTextField();
        versionTxt = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        dispTxt1 = new javax.swing.JTextField();
        dispTxt2 = new javax.swing.JTextField();
        initializeBtn = new javax.swing.JButton();
        backlightChk = new javax.swing.JCheckBox();
        cursorChk = new javax.swing.JCheckBox();
        blinkChk = new javax.swing.JCheckBox();
        customChk = new javax.swing.JCheckBox();
        jLabel6 = new javax.swing.JLabel();
        contrastSlide = new javax.swing.JSlider();
        jLabel7 = new javax.swing.JLabel();
        brightnessSlide = new javax.swing.JSlider();
        jLabel8 = new javax.swing.JLabel();
        screenCmb = new javax.swing.JComboBox();
        screenSizeCmb = new javax.swing.JComboBox();
        jLabel9 = new javax.swing.JLabel();
        dispTxt3 = new javax.swing.JTextField();
        dispTxt4 = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("TextLCD - full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Device Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 36, -1, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 61, -1, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 138, -1, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 164, -1, -1));

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 33, 172, -1));

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(2);
        nameTxt.setTabSize(2);
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 61, 172, 63));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 135, 172, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 161, 172, -1));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("LCD Control"));
        jPanel2.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel5.setText("Display Text:");
        jPanel2.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 107, -1, -1));

        dispTxt1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                dispTxt1KeyReleased(evt);
            }
        });
        jPanel2.add(dispTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 140, 190, -1));

        dispTxt2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                dispTxt2KeyReleased(evt);
            }
        });
        jPanel2.add(dispTxt2, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 170, 190, -1));

        initializeBtn.setText("Initialize");
        initializeBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                initializeBtnActionPerformed(evt);
            }
        });
        jPanel2.add(initializeBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(160, 104, -1, -1));

        backlightChk.setText("Backlight");
        backlightChk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        backlightChk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        backlightChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backlightChkActionPerformed(evt);
            }
        });
        jPanel2.add(backlightChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 260, -1, -1));

        cursorChk.setText("Cursor");
        cursorChk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        cursorChk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        cursorChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cursorChkActionPerformed(evt);
            }
        });
        jPanel2.add(cursorChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 290, -1, -1));

        blinkChk.setText("Cursor Blink");
        blinkChk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        blinkChk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        blinkChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                blinkChkActionPerformed(evt);
            }
        });
        jPanel2.add(blinkChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(120, 260, -1, -1));

        customChk.setText("Custom Characters");
        customChk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        customChk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        customChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                customChkActionPerformed(evt);
            }
        });
        jPanel2.add(customChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(120, 290, -1, -1));

        jLabel6.setText("Contrast:");
        jPanel2.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 320, -1, -1));

        contrastSlide.setPaintTicks(true);
        contrastSlide.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                contrastSlideStateChanged(evt);
            }
        });
        jPanel2.add(contrastSlide, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 340, 190, -1));

        jLabel7.setText("Brightness:");
        jPanel2.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 380, -1, -1));

        brightnessSlide.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brightnessSlideStateChanged(evt);
            }
        });
        jPanel2.add(brightnessSlide, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 400, 190, -1));

        jLabel8.setText("Screen:");
        jPanel2.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 42, -1, -1));

        screenCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                screenCmbActionPerformed(evt);
            }
        });
        jPanel2.add(screenCmb, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 40, 140, -1));

        screenSizeCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                screenSizeCmbActionPerformed(evt);
            }
        });
        jPanel2.add(screenSizeCmb, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 70, 140, -1));

        jLabel9.setText("Screen Size:");
        jPanel2.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 72, -1, -1));

        dispTxt3.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                dispTxt3KeyReleased(evt);
            }
        });
        jPanel2.add(dispTxt3, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 200, 190, -1));

        dispTxt4.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                dispTxt4KeyReleased(evt);
            }
        });
        jPanel2.add(dispTxt4, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 230, 190, -1));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 262, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 262, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 193, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 433, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        try {
            lcd = new TextLCDPhidget();

            screenSizeHashTable = new Hashtable();
            screenSizeHashTable.put("None", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_NONE);
            screenSizeHashTable.put("1x16", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_1x16);
            screenSizeHashTable.put("1x40", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_1x40);
            screenSizeHashTable.put("1x8", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_1x8);
            screenSizeHashTable.put("2x16", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_2x16);
            screenSizeHashTable.put("2x20", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_2x20);
            screenSizeHashTable.put("2x24", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_2x24);
            screenSizeHashTable.put("2x40", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_2x40);
            screenSizeHashTable.put("2x8", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_2x8);
            screenSizeHashTable.put("4x16", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_4x16);
            screenSizeHashTable.put("4x20", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_4x20);
            screenSizeHashTable.put("4x40", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_4x40);
            screenSizeHashTable.put("Unknown", TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_UNKNOWN);

            this.dispTxt1.setEnabled(false);
            this.dispTxt2.setEnabled(false);
            this.dispTxt3.setEnabled(false);
            this.dispTxt4.setEnabled(false);
            this.dispTxt1.setEditable(false);
            this.dispTxt2.setEditable(false);
            this.dispTxt3.setEditable(false);
            this.dispTxt4.setEditable(false);
            this.backlightChk.setEnabled(false);
            this.cursorChk.setEnabled(false);
            this.blinkChk.setEnabled(false);
            this.customChk.setEnabled(false);
            this.contrastSlide.setEnabled(false);
            this.brightnessSlide.setEnabled(false);

            screenCmb.setEnabled(false);
            screenSizeCmb.setEnabled(false);
            initializeBtn.setEnabled(false);

            attach_listener = new LCDAttachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1,
                    this.dispTxt2, this.dispTxt3, this.dispTxt4, this.backlightChk,
                    this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide, this.brightnessSlide,
                    this.screenCmb, this.screenSizeCmb, this.initializeBtn, this.screenSizeHashTable);

            detach_listener = new LCDDetachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt, this.dispTxt1,
                    this.dispTxt2, this.dispTxt3, this.dispTxt4, this.backlightChk,
                    this.cursorChk, this.blinkChk, this.customChk, this.contrastSlide, this.brightnessSlide,
                    this.screenCmb, this.screenSizeCmb, this.initializeBtn);

            error_listener = new LCDErrorListener(this);

            lcd.addAttachListener(attach_listener);
            lcd.addDetachListener(detach_listener);
            lcd.addErrorListener(error_listener);

            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                lcd.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                lcd.open(Integer.parseInt(runArgs[0]));
            } else {
                lcd.openAny();
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try {
            lcd.removeAttachListener(attach_listener);
            lcd.removeDetachListener(detach_listener);
            lcd.removeErrorListener(error_listener);
            lcd.close();
            lcd = null;

            dispose();
            System.exit(0);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    private void contrastSlideStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_contrastSlideStateChanged
        try {
            this.lcd.setContrast(this.contrastSlide.getValue());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_contrastSlideStateChanged

    //Writes custom characters to row 1. The screen must contain atleast 
    private void customChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customChkActionPerformed
        if (this.customChk.isEnabled()) {
            try {
                this.lcd.setDisplayString(0, "Custom Chars");
                this.lcd.setCustomCharacter(8, 949247, 536);
                this.lcd.setCustomCharacter(9, 1015791, 17180);
                this.lcd.setCustomCharacter(10, 1048039, 549790);
                this.lcd.setCustomCharacter(11, 1031395, 816095);
                this.lcd.setCustomCharacter(12, 498785, 949247);
                this.lcd.setCustomCharacter(13, 232480, 1015791);
                this.lcd.setCustomCharacter(14, 99328, 1048039);

                this.lcd.setDisplayString(1, "\010\011\012\013\014\015\016"); //representation is in octal
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }

        } else {
            try {
                this.lcd.setDisplayString(0, "");
                this.lcd.setDisplayString(1, "");
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }

        }
    }//GEN-LAST:event_customChkActionPerformed

    private void blinkChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_blinkChkActionPerformed
        try {
            this.lcd.setCursorBlink(this.blinkChk.isSelected());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_blinkChkActionPerformed

    private void cursorChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cursorChkActionPerformed
        try {
            this.lcd.setCursor(this.cursorChk.isSelected());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_cursorChkActionPerformed

    private void backlightChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backlightChkActionPerformed
        try {
            this.lcd.setBacklight(this.backlightChk.isSelected());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_backlightChkActionPerformed

    private void initializeBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_initializeBtnActionPerformed

        clearTextFields();
        try {
            if (lcd.getDeviceID() == TextLCDPhidget.PHIDID_TEXTLCD_ADAPTER) {
                lcd.initialize();
            } else {
                this.lcd.setDisplayString(0, "");
                this.lcd.setDisplayString(1, "");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }


    }//GEN-LAST:event_initializeBtnActionPerformed

    private void dispTxt2KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_dispTxt2KeyReleased
        try {
            this.lcd.setDisplayString(1, this.dispTxt2.getText());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_dispTxt2KeyReleased

    private void dispTxt1KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_dispTxt1KeyReleased
        try {
            this.lcd.setDisplayString(0, this.dispTxt1.getText());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_dispTxt1KeyReleased

    private void screenCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_screenCmbActionPerformed
        try {
            if (lcd.isAttached()) {
                int index = ((Integer) screenCmb.getSelectedItem()).intValue();

                //keep copy of orginal rows
                int i, j;

                //make a copy of all text
                textOriginals[currScreen][0] = dispTxt1.getText();
                textOriginals[currScreen][1] = dispTxt2.getText();
                textOriginals[currScreen][2] = dispTxt3.getText();
                textOriginals[currScreen][3] = dispTxt4.getText();

                //keep copy of new screen

                currScreen = index;

                //display text for the current screen
                dispTxt1.setText(textOriginals[index][0]);
                dispTxt2.setText(textOriginals[index][1]);
                dispTxt3.setText(textOriginals[index][2]);
                dispTxt4.setText(textOriginals[index][3]);

                lcd.setScreen(index);

                setScreenSizeCmb();

                backlightChk.setSelected(lcd.getBacklight());

                try {
                    blinkChk.setSelected(lcd.getCursorBlink());
                    cursorChk.setSelected(lcd.getCursor());
                } catch (PhidgetException cursorE) {
                }

                contrastSlide.setValue(lcd.getContrast());

                try {
                    brightnessSlide.setValue(lcd.getContrast());
                } catch (PhidgetException brightnessE) {
                }
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);

        }
    }//GEN-LAST:event_screenCmbActionPerformed

    private void screenSizeCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_screenSizeCmbActionPerformed

        String index = ((String) screenSizeCmb.getSelectedItem());
        try {
            if (lcd.isAttached()) {
                int value = ((Integer) (screenSizeHashTable.get(screenSizeCmb.getSelectedItem())));
                if (value == TextLCDPhidget.PHIDGET_TEXTLCD_SCREEN_UNKNOWN) {
                    setAllTextFieldProperties(0);
                } else {
                    lcd.setScreenSize(value);
                    setRowEnables();
                }
            }
        } catch (PhidgetException ex) {
        }

    }//GEN-LAST:event_screenSizeCmbActionPerformed

    private void dispTxt3KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_dispTxt3KeyReleased
        try {
            this.lcd.setDisplayString(2, this.dispTxt3.getText());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_dispTxt3KeyReleased

    private void dispTxt4KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_dispTxt4KeyReleased
        try {
            this.lcd.setDisplayString(3, this.dispTxt4.getText());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_dispTxt4KeyReleased

    private void brightnessSlideStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brightnessSlideStateChanged
        try {
            this.lcd.setBrightness(this.brightnessSlide.getValue());
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_brightnessSlideStateChanged

    private void setRowEnables() {
        //   int size = ((Integer) screenSizeCmb.getSelectedItem()).intValue();
        try {
            int rows = lcd.getRowCount();
            setAllTextFieldProperties(rows);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }

    private void clearTextFields() {
        this.dispTxt1.setText("");
        this.dispTxt2.setText("");
        this.dispTxt3.setText("");
        this.dispTxt4.setText("");

        int i, j;
        for (i = 0; i < 2; i++) {
            for (j = 0; j < 4; j++) {
                textOriginals[i][j] = "";
            }
        }
    }

    private void setFieldProperties(JTextField dispTxt, boolean state) {
        String tempText = dispTxt.getText();
        dispTxt.setEditable(state);
        dispTxt.setEnabled(state);

        try {

            dispTxt.setDocument(new TextFieldLimiter(lcd.getColumnCount()));
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
        dispTxt.setText(tempText);
    }

    private void setAllTextFieldProperties(int rows) {
        switch (rows) {
            case 1:
                setFieldProperties(dispTxt1, true);
                setFieldProperties(dispTxt2, false);
                setFieldProperties(dispTxt3, false);
                setFieldProperties(dispTxt4, false);
                break;
            case 2:
                setFieldProperties(dispTxt1, true);
                setFieldProperties(dispTxt2, true);
                setFieldProperties(dispTxt3, false);
                setFieldProperties(dispTxt4, false);
                break;
            case 3:
                setFieldProperties(dispTxt1, true);
                setFieldProperties(dispTxt2, true);
                setFieldProperties(dispTxt3, true);
                setFieldProperties(dispTxt4, false);
                break;
            case 4:
                setFieldProperties(dispTxt1, true);
                setFieldProperties(dispTxt2, true);
                setFieldProperties(dispTxt3, true);
                setFieldProperties(dispTxt4, true);
                break;
            default:
                setFieldProperties(dispTxt1, false);
                setFieldProperties(dispTxt2, false);
                setFieldProperties(dispTxt3, false);
                setFieldProperties(dispTxt4, false);
                break;
        }
    }

    private void setScreenSizeCmb() {
        Enumeration eKeys = screenSizeHashTable.keys();
        int element;
        try {
            element = lcd.getScreenSize();

            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if (((Integer) screenSizeHashTable.get(currKey)).intValue() == element) {
                    screenSizeCmb.setSelectedItem(currKey);
                }
            }
        } catch (PhidgetException ex) {
            screenSizeCmb.setSelectedItem("Unknown");
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new TextLCD().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JCheckBox backlightChk;
    private javax.swing.JCheckBox blinkChk;
    private javax.swing.JSlider brightnessSlide;
    private javax.swing.JSlider contrastSlide;
    private javax.swing.JCheckBox cursorChk;
    private javax.swing.JCheckBox customChk;
    private javax.swing.JTextField dispTxt1;
    private javax.swing.JTextField dispTxt2;
    private javax.swing.JTextField dispTxt3;
    private javax.swing.JTextField dispTxt4;
    private javax.swing.JButton initializeBtn;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JComboBox screenCmb;
    private javax.swing.JComboBox screenSizeCmb;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
